<!DOCTYPE html>
<html>
<head>
    <title>Login</title>
    <style>
        .error { color: red; margin-bottom: 10px; }
        form { max-width: 300px; }
        div { margin-bottom: 10px; }
        input, button { width: 100%; padding: 8px; }
    </style>
</head>
<body>
    <h2>Login</h2>
    @if ($errors->any())
        <div class="error">
            @foreach ($errors->all() as $error)
                <p>{{ $error }}</p>
            @endforeach
        </div>
    @endif
    <form method="POST" action="/login">
        @csrf <!-- Included but bypassed by middleware -->
        <div>
            <label for="identifier">Email or Mobile</label>
            <input type="text" name="identifier" id="identifier" value="{{ old('identifier') }}" required>
        </div>
        <div>
            <label for="password">Password</label>
            <input type="password" name="password" id="password" required>
        </div>
        <button type="submit">Login</button>
    </form>
    <p>CSRF Token: {{ csrf_token() }}</p>
</body>
</html>
